<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Notification;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\Notification\NotificationTable;

final class NotificationFinder extends AbstractFinder implements InterfaceNotificationSetter
{
    /**
     * setter interface
     */
    use TraitNotificationSetters;

    public function getTableName(): string
    {
        return NotificationTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {NotificationTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): NotificationModel
    {
        return NotificationModel::createFromUntouchedBean_noException(parent::pop());
    }
}
